/*
 * Decompiled with CFR 0.152.
 */
package com.initialde.dgttCheckDocApi.shared.infrastructure.persistence;

import com.initialde.dgttCheckDocApi.models.Document;
import com.initialde.dgttCheckDocApi.repositories.JpaDocumentRepository;
import com.initialde.dgttCheckDocApi.shared.infrastructure.persistence.DocumentRepository;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/initialde/dgttCheckDocApi/shared/infrastructure/persistence/DocumentRepositoryImpl;", "Lcom/initialde/dgttCheckDocApi/shared/infrastructure/persistence/DocumentRepository;", "jpaDocumentRepository", "Lcom/initialde/dgttCheckDocApi/repositories/JpaDocumentRepository;", "(Lcom/initialde/dgttCheckDocApi/repositories/JpaDocumentRepository;)V", "delete", "", "document", "Lcom/initialde/dgttCheckDocApi/models/Document;", "deleteAll", "findAll", "", "findById", "id", "", "findByIdentificationNumber", "identifier", "", "save", "dgttCheckDocApi"})
public class DocumentRepositoryImpl
implements DocumentRepository {
    @NotNull
    private final JpaDocumentRepository jpaDocumentRepository;

    public DocumentRepositoryImpl(@NotNull JpaDocumentRepository jpaDocumentRepository) {
        Intrinsics.checkNotNullParameter((Object)jpaDocumentRepository, (String)"jpaDocumentRepository");
        this.jpaDocumentRepository = jpaDocumentRepository;
    }

    @Nullable
    public Document findById(long id) {
        Optional optional = this.jpaDocumentRepository.findById((Object)id);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findById(...)");
        Optional optDocument = optional;
        if (optDocument.isEmpty()) {
            return null;
        }
        return (Document)optDocument.get();
    }

    @Nullable
    public Document findByIdentificationNumber(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.jpaDocumentRepository.findByIdentificationNumber(identifier);
    }

    @NotNull
    public Document save(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Object object = this.jpaDocumentRepository.save((Object)document);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        return (Document)object;
    }

    @NotNull
    public List<Document> findAll() {
        List list = this.jpaDocumentRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAll(...)");
        return list;
    }

    public void delete(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.jpaDocumentRepository.delete((Object)document);
    }

    public void deleteAll() {
        this.jpaDocumentRepository.deleteAll();
    }
}

