/*
 * Decompiled with CFR 0.152.
 */
package com.initialde.dgttCheckDocApi.services;

import com.initialde.dgttCheckDocApi.deleteDocument.infrastructure.FileStorageService;
import com.initialde.dgttCheckDocApi.services.FileStorageServiceImpl;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/initialde/dgttCheckDocApi/services/FileStorageServiceImpl;", "Lcom/initialde/dgttCheckDocApi/deleteDocument/infrastructure/FileStorageService;", "()V", "storageLocation", "Ljava/nio/file/Path;", "deleteAllFiles", "", "deleteFile", "filename", "", "storeFile", "file", "Lorg/springframework/web/multipart/MultipartFile;", "storeFiles", "", "files", "dgttCheckDocApi"})
public class FileStorageServiceImpl
implements FileStorageService {
    @NotNull
    private final Path storageLocation;

    public FileStorageServiceImpl() {
        Path path = Paths.get("uploads", new String[0]).toAbsolutePath().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
        this.storageLocation = path;
        Files.createDirectories(this.storageLocation, new FileAttribute[0]);
    }

    @NotNull
    public String storeFile(@NotNull MultipartFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getOriginalFilename();
        if (string == null) {
            throw new IllegalArgumentException("File must have a name");
        }
        String originalFilename = string;
        String fileExtension = StringsKt.substringAfterLast((String)originalFilename, (char)'.', (String)"");
        String uniqueFilename = UUID.randomUUID() + "." + fileExtension;
        Path targetLocation = this.storageLocation.resolve(uniqueFilename);
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(file.getInputStream(), targetLocation, copyOptionArray);
        return uniqueFilename;
    }

    @NotNull
    public List<String> storeFiles(@NotNull List<? extends MultipartFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        List fileNames = new ArrayList();
        for (MultipartFile multipartFile : files) {
            String fileName = String.valueOf(multipartFile.getOriginalFilename());
            try {
                Path filePath = this.storageLocation.resolve(fileName);
                multipartFile.transferTo(filePath);
                fileNames.add(fileName);
            }
            catch (Exception e) {
                throw new RuntimeException("Erreur lors de l'enregistrement du fichier : " + multipartFile.getOriginalFilename(), e);
            }
        }
        return fileNames;
    }

    public void deleteFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path filePath = this.storageLocation.resolve(filename).normalize();
        Files.deleteIfExists(filePath);
    }

    public void deleteAllFiles() {
        try {
            Files.walk(this.storageLocation, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).filter(arg_0 -> FileStorageServiceImpl.deleteAllFiles$lambda$0((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).forEach(arg_0 -> FileStorageServiceImpl.deleteAllFiles$lambda$1((Function1)deleteAllFiles.2.INSTANCE, arg_0));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to delete files", e);
        }
    }

    private static final boolean deleteAllFiles$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void deleteAllFiles$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Path access$getStorageLocation$p(FileStorageServiceImpl $this) {
        return $this.storageLocation;
    }
}

