/*
 * Decompiled with CFR 0.152.
 */
package com.initialde.dgttCheckDocApi.services;

import com.initialde.dgttCheckDocApi.models.Document;
import com.initialde.dgttCheckDocApi.models.VerificationStatus;
import com.initialde.dgttCheckDocApi.services.ExcelService;
import java.io.InputStream;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0012J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0012J\u0012\u0010\t\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0012J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/initialde/dgttCheckDocApi/services/ExcelService;", "", "()V", "getDateCellValue", "", "cell", "Lorg/apache/poi/ss/usermodel/Cell;", "getNumericCellValue", "", "getStringCellValue", "readExcelFile", "", "Lcom/initialde/dgttCheckDocApi/models/Document;", "inputStream", "Ljava/io/InputStream;", "dgttCheckDocApi"})
public class ExcelService {
    @NotNull
    public List<Document> readExcelFile(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
        Sheet sheet = workbook.getSheetAt(0);
        List dataList = new ArrayList();
        Intrinsics.checkNotNull((Object)sheet);
        for (Row row : CollectionsKt.drop((Iterable)((Iterable)sheet), (int)1)) {
            String identificationNumber = this.getStringCellValue(row.getCell(12));
            String type = "Carte professionnelle de conducteur de taxi";
            VerificationStatus status = VerificationStatus.PENDING;
            String name = this.getStringCellValue(row.getCell(0));
            String firstname = this.getStringCellValue(row.getCell(1));
            String nationality = this.getStringCellValue(row.getCell(2));
            String birthPlace = this.getStringCellValue(row.getCell(4));
            String sex = this.getStringCellValue(row.getCell(5));
            String identityCardType = this.getStringCellValue(row.getCell(6));
            String identityCardNumber = this.getStringCellValue(row.getCell(7));
            String licenseDriving = this.getStringCellValue(row.getCell(8));
            String deliveryCity = this.getStringCellValue(row.getCell(14));
            String folderNumber = this.getStringCellValue(row.getCell(13));
            String birthDate = this.getDateCellValue(row.getCell(3));
            String expireDate = this.getDateCellValue(row.getCell(10));
            String establishedDate = this.getDateCellValue(row.getCell(11));
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Nom(s)", (Object)name), TuplesKt.to((Object)"Pr\u00e9nom(s)", (Object)firstname), TuplesKt.to((Object)"Nationalit\u00e9", (Object)nationality), TuplesKt.to((Object)"Date et lieu de naissance", (Object)(birthDate + " \u00e0 " + birthPlace)), TuplesKt.to((Object)"Sexe", (Object)sex), TuplesKt.to((Object)("N\u00b0 " + identityCardType), (Object)identityCardNumber), TuplesKt.to((Object)"N\u00b0 Permis de conduire", (Object)licenseDriving), TuplesKt.to((Object)"Ville de d\u00e9livrance", (Object)deliveryCity), TuplesKt.to((Object)"Date de fin de validit\u00e9", (Object)expireDate), TuplesKt.to((Object)"N\u00b0 DOSSIER", (Object)folderNumber), TuplesKt.to((Object)"Fait le", (Object)establishedDate)};
            Map additionalInfo2 = MapsKt.mapOf((Pair[])pairArray);
            String imagePath = row.getCell(9).getStringCellValue();
            String string = imagePath + ".png";
            Document entity = new Document(0L, identificationNumber, type, status, additionalInfo2, string, 1, null);
            dataList.add(entity);
        }
        workbook.close();
        return dataList;
    }

    private String getStringCellValue(Cell cell) {
        String string;
        Cell cell2 = cell;
        Object object = cell2 != null ? cell2.getCellType() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1: {
                String string2 = cell.getStringCellValue();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStringCellValue(...)");
                break;
            }
            case 2: {
                string = String.valueOf(cell.getNumericCellValue());
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private double getNumericCellValue(Cell cell) {
        Cell cell2 = cell;
        Object object = cell2 != null ? cell2.getCellType() : null;
        return switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 2 -> cell.getNumericCellValue();
            case 1 -> {
                String v3 = cell.getStringCellValue();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getStringCellValue(...)");
                Double v4 = StringsKt.toDoubleOrNull((String)v3);
                if (v4 != null) {
                    yield v4;
                }
                yield 0.0;
            }
            default -> 0.0;
        };
    }

    private String getDateCellValue(Cell cell) {
        String string;
        if (cell != null && cell.getCellType() == CellType.NUMERIC && DateUtil.isCellDateFormatted((Cell)cell)) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
            String string2 = cell.getDateCellValue().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().format(formatter);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = "";
        }
        return string;
    }
}

