/*
 * Decompiled with CFR 0.152.
 */
package com.initialde.dgttCheckDocApi.login.infrastructure.authentication.token.jwt;

import com.initialde.dgttCheckDocApi.login.infrastructure.authentication.token.jwt.JwtService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/token/jwt/JwtAuthenticationFilter;", "Lorg/springframework/web/filter/OncePerRequestFilter;", "jwtService", "Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/token/jwt/JwtService;", "userDetailsService", "Lorg/springframework/security/core/userdetails/UserDetailsService;", "(Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/token/jwt/JwtService;Lorg/springframework/security/core/userdetails/UserDetailsService;)V", "doFilterInternal", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "filterChain", "Ljakarta/servlet/FilterChain;", "dgttCheckDocApi"})
public class JwtAuthenticationFilter
extends OncePerRequestFilter {
    @NotNull
    private final JwtService jwtService;
    @NotNull
    private final UserDetailsService userDetailsService;

    @Autowired
    public JwtAuthenticationFilter(@NotNull JwtService jwtService, @NotNull UserDetailsService userDetailsService) {
        Intrinsics.checkNotNullParameter((Object)jwtService, (String)"jwtService");
        Intrinsics.checkNotNullParameter((Object)userDetailsService, (String)"userDetailsService");
        this.jwtService = jwtService;
        this.userDetailsService = userDetailsService;
    }

    protected void doFilterInternal(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain filterChain) throws ServletException, IOException {
        UserDetails userDetails;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)filterChain, (String)"filterChain");
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || !StringsKt.startsWith$default((String)authHeader, (String)"Bearer ", (boolean)false, (int)2, null)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String string = authHeader.substring(7);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String jwt = string;
        String username = this.jwtService.extractUsername(jwt);
        if (username != null && SecurityContextHolder.getContext().getAuthentication() == null && this.jwtService.isTokenValid(jwt, userDetails = this.userDetailsService.loadUserByUsername(username))) {
            UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
            authToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
            SecurityContextHolder.getContext().setAuthentication((Authentication)authToken);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

