/*
 * Decompiled with CFR 0.152.
 */
package com.initialde.dgttCheckDocApi.login.infrastructure.authentication.token.jwt;

import com.initialde.dgttCheckDocApi.login.application.query.LoginRequest;
import com.initialde.dgttCheckDocApi.login.infrastructure.authentication.token.TokenGenerator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.core.userdetails.UserDetails;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\r2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/token/jwt/FakeJwtService;", "Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/token/TokenGenerator;", "()V", "token", "", "tokens", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "extractUsername", "generateToken", "loginRequest", "Lcom/initialde/dgttCheckDocApi/login/application/query/LoginRequest;", "isTokenValid", "", "userDetails", "Lorg/springframework/security/core/userdetails/UserDetails;", "setupFakeToken", "", "dgttCheckDocApi"})
public final class FakeJwtService
implements TokenGenerator {
    @NotNull
    private final LinkedHashMap<String, String> tokens = new LinkedHashMap();
    @NotNull
    private String token = "";

    public final void setupFakeToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.token = token;
    }

    @NotNull
    public String generateToken(@NotNull LoginRequest loginRequest) {
        Intrinsics.checkNotNullParameter((Object)loginRequest, (String)"loginRequest");
        String fakeToken = this.token;
        ((Map)this.tokens).put(fakeToken, loginRequest.getUsername());
        return fakeToken;
    }

    @Nullable
    public String extractUsername(@Nullable String token) {
        return (String)((Map)this.tokens).get(token);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTokenValid(@Nullable String token, @Nullable UserDetails userDetails) {
        String username = this.extractUsername(token);
        if (username == null) return false;
        UserDetails userDetails2 = userDetails;
        if (!Intrinsics.areEqual((Object)username, (Object)(userDetails2 != null ? userDetails2.getUsername() : null))) return false;
        if (token == null) return false;
        return true;
    }
}

