/*
 * Decompiled with CFR 0.152.
 */
package com.initialde.dgttCheckDocApi.login.infrastructure.authentication;

import com.initialde.dgttCheckDocApi.login.application.query.LoginRequest;
import com.initialde.dgttCheckDocApi.login.domain.User;
import com.initialde.dgttCheckDocApi.login.infrastructure.authentication.AuthenticationGateway;
import com.initialde.dgttCheckDocApi.login.infrastructure.authentication.token.TokenGenerator;
import com.initialde.dgttCheckDocApi.login.infrastructure.persistence.UserRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/AuthenticationGatewayImpl;", "Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/AuthenticationGateway;", "tokenGenerator", "Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/token/TokenGenerator;", "userRepository", "Lcom/initialde/dgttCheckDocApi/login/infrastructure/persistence/UserRepository;", "authenticationManager", "Lorg/springframework/security/authentication/AuthenticationManager;", "(Lcom/initialde/dgttCheckDocApi/login/infrastructure/authentication/token/TokenGenerator;Lcom/initialde/dgttCheckDocApi/login/infrastructure/persistence/UserRepository;Lorg/springframework/security/authentication/AuthenticationManager;)V", "authenticate", "", "loginRequest", "Lcom/initialde/dgttCheckDocApi/login/application/query/LoginRequest;", "getAuthenticatedUser", "Lcom/initialde/dgttCheckDocApi/login/domain/User;", "dgttCheckDocApi"})
public class AuthenticationGatewayImpl
implements AuthenticationGateway {
    @NotNull
    private final TokenGenerator tokenGenerator;
    @NotNull
    private final UserRepository userRepository;
    @NotNull
    private final AuthenticationManager authenticationManager;

    @Autowired
    public AuthenticationGatewayImpl(@NotNull TokenGenerator tokenGenerator, @NotNull UserRepository userRepository, @NotNull AuthenticationManager authenticationManager) {
        Intrinsics.checkNotNullParameter((Object)tokenGenerator, (String)"tokenGenerator");
        Intrinsics.checkNotNullParameter((Object)userRepository, (String)"userRepository");
        Intrinsics.checkNotNullParameter((Object)authenticationManager, (String)"authenticationManager");
        this.tokenGenerator = tokenGenerator;
        this.userRepository = userRepository;
        this.authenticationManager = authenticationManager;
    }

    @NotNull
    public String authenticate(@NotNull LoginRequest loginRequest) {
        Intrinsics.checkNotNullParameter((Object)loginRequest, (String)"loginRequest");
        Authentication authenticationRequest = (Authentication)new UsernamePasswordAuthenticationToken((Object)loginRequest.getUsername(), (Object)loginRequest.getPassword());
        Authentication authentication = this.authenticationManager.authenticate(authenticationRequest);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        return this.tokenGenerator.generateToken(loginRequest);
    }

    @NotNull
    public User getAuthenticatedUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new AuthenticationCredentialsNotFoundException("No authentication found");
        }
        Authentication authentication2 = authentication;
        String string = authentication2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Object t = this.userRepository.findByUsername(string).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (User)t;
    }
}

