/*
 * Decompiled with CFR 0.152.
 */
package com.initialde.dgttCheckDocApi.controllers;

import com.initialde.dgttCheckDocApi.ScanDocument.application.ScanDocumentHandler;
import com.initialde.dgttCheckDocApi.controllers.VerifyDocumentRequest;
import com.initialde.dgttCheckDocApi.models.Document;
import com.initialde.dgttCheckDocApi.models.VerificationResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\b\b\u0001\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/initialde/dgttCheckDocApi/controllers/ScanDocumentController;", "", "scanDocumentHandler", "Lcom/initialde/dgttCheckDocApi/ScanDocument/application/ScanDocumentHandler;", "(Lcom/initialde/dgttCheckDocApi/ScanDocument/application/ScanDocumentHandler;)V", "scanDocument", "Lorg/springframework/http/ResponseEntity;", "Lcom/initialde/dgttCheckDocApi/models/VerificationResult;", "Lcom/initialde/dgttCheckDocApi/models/Document;", "request", "Lcom/initialde/dgttCheckDocApi/controllers/VerifyDocumentRequest;", "dgttCheckDocApi"})
public class ScanDocumentController {
    @NotNull
    private final ScanDocumentHandler scanDocumentHandler;

    public ScanDocumentController(@NotNull ScanDocumentHandler scanDocumentHandler) {
        Intrinsics.checkNotNullParameter((Object)scanDocumentHandler, (String)"scanDocumentHandler");
        this.scanDocumentHandler = scanDocumentHandler;
    }

    @PostMapping(value={"/verify/document"})
    @NotNull
    public ResponseEntity<VerificationResult<Document>> scanDocument(@RequestBody @NotNull VerifyDocumentRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        VerificationResult result = this.scanDocumentHandler.handle(request.getDocumentCode(), request.getLatitude(), request.getLongitude());
        ResponseEntity responseEntity = ResponseEntity.ok((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }
}

