/*
 * Decompiled with CFR 0.152.
 */
package com.initialde.dgttCheckDocApi.controllers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.initialde.dgttCheckDocApi.models.Document;
import com.initialde.dgttCheckDocApi.models.DocumentRequest;
import com.initialde.dgttCheckDocApi.models.VerificationStatus;
import com.initialde.dgttCheckDocApi.services.DocumentService;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/v1"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0017J\u0014\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0006H\u0017J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\b\b\u0001\u0010\f\u001a\u00020\u0007H\u0017J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\b\b\u0001\u0010\f\u001a\u00020\u0007H\u0017J\b\u0010\u000f\u001a\u00020\u0007H\u0017JB\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\b\b\u0001\u0010\f\u001a\u00020\u00072\b\b\u0001\u0010\u0011\u001a\u00020\u00072\b\b\u0001\u0010\u0012\u001a\u00020\u00072\b\b\u0001\u0010\u0013\u001a\u00020\u00072\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0017J$\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00062\u000e\b\u0001\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\tH\u0017J\"\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\b\b\u0001\u0010\f\u001a\u00020\u00072\b\b\u0001\u0010\u001a\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/initialde/dgttCheckDocApi/controllers/DocumentController;", "", "documentService", "Lcom/initialde/dgttCheckDocApi/services/DocumentService;", "(Lcom/initialde/dgttCheckDocApi/services/DocumentService;)V", "deleteAllDocuments", "Lorg/springframework/http/ResponseEntity;", "", "getAllDocuments", "", "Lcom/initialde/dgttCheckDocApi/models/Document;", "getDocument", "identificationNumber", "getStatus", "Lcom/initialde/dgttCheckDocApi/models/VerificationStatus;", "index", "saveDocument", "type", "status", "additionalInfoJson", "image", "Lorg/springframework/web/multipart/MultipartFile;", "saveDocuments", "documents", "Lcom/initialde/dgttCheckDocApi/models/DocumentRequest;", "updateDocument", "updatedDocument", "dgttCheckDocApi"})
public class DocumentController {
    @NotNull
    private final DocumentService documentService;

    public DocumentController(@NotNull DocumentService documentService) {
        Intrinsics.checkNotNullParameter((Object)documentService, (String)"documentService");
        this.documentService = documentService;
    }

    @GetMapping(value={"/"})
    @NotNull
    public String index() {
        return "Bienvenue sur notre API de v\u00e9rification des documents";
    }

    @GetMapping(value={"/document/{identificationNumber}"})
    @NotNull
    public ResponseEntity<Document> getDocument(@PathVariable @NotNull String identificationNumber) {
        Intrinsics.checkNotNullParameter((Object)identificationNumber, (String)"identificationNumber");
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.documentService.getDocument(identificationNumber));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @GetMapping(value={"/verify/document/{identificationNumber}/status"})
    @NotNull
    public ResponseEntity<VerificationStatus> getStatus(@PathVariable @NotNull String identificationNumber) {
        ResponseEntity responseEntity;
        VerificationStatus status;
        Intrinsics.checkNotNullParameter((Object)identificationNumber, (String)"identificationNumber");
        VerificationStatus verificationStatus = status = this.documentService.getStatus(identificationNumber);
        if (verificationStatus != null) {
            ResponseEntity responseEntity2 = ResponseEntity.ok((Object)verificationStatus);
            responseEntity = responseEntity2;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"ok(...)");
        } else {
            ResponseEntity responseEntity3 = ResponseEntity.notFound().build();
            responseEntity = responseEntity3;
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity3, (String)"build(...)");
        }
        return responseEntity;
    }

    @PostMapping(value={"/document"}, consumes={"multipart/form-data"})
    @NotNull
    public ResponseEntity<Document> saveDocument(@RequestParam(value="identificationNumber") @NotNull String identificationNumber, @RequestParam(value="type") @NotNull String type, @RequestParam(value="status") @NotNull String status, @RequestParam(value="additionalInfo") @NotNull String additionalInfoJson, @RequestParam(value="image") @Nullable MultipartFile image) {
        Intrinsics.checkNotNullParameter((Object)identificationNumber, (String)"identificationNumber");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)additionalInfoJson, (String)"additionalInfoJson");
        Object object = new ObjectMapper().readValue(additionalInfoJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        Map additionalInfo2 = (Map)object;
        Document savedDocument = this.documentService.saveDocument(identificationNumber, status, type, additionalInfo2, image);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)savedDocument);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @PostMapping(value={"/documents"})
    @NotNull
    public ResponseEntity<List<Document>> saveDocuments(@RequestBody @NotNull List<DocumentRequest> documents) {
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        List savedDocuments = this.documentService.saveDocuments(documents);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)savedDocuments);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @PutMapping(value={"/document/{identificationNumber}"})
    @NotNull
    public ResponseEntity<Document> updateDocument(@PathVariable @NotNull String identificationNumber, @RequestBody @NotNull Document updatedDocument) {
        Intrinsics.checkNotNullParameter((Object)identificationNumber, (String)"identificationNumber");
        Intrinsics.checkNotNullParameter((Object)updatedDocument, (String)"updatedDocument");
        Document updatedDocument2 = this.documentService.updateDocument(identificationNumber, updatedDocument);
        ResponseEntity responseEntity = ResponseEntity.ok((Object)updatedDocument2);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @GetMapping(value={"/documents"})
    @NotNull
    public ResponseEntity<List<Document>> getAllDocuments() {
        List documents = this.documentService.getAllDocuments();
        ResponseEntity responseEntity = ResponseEntity.ok((Object)documents);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @DeleteMapping(value={"/documents"})
    @NotNull
    public ResponseEntity<String> deleteAllDocuments() {
        this.documentService.deleteAllDocuments();
        ResponseEntity responseEntity = ResponseEntity.ok((Object)"All documents deleted");
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }
}

